/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.HashSet;
import org.codefilarete.stalactite.engine.PersistExecutor;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class PersistExecutorTest {
    PersistExecutorTest() {
    }

    @Test
    void forPersister_notAlreadyAssignedIdentifier_persistIsBasedOnIsNewAndDatabaseSelect() {
        ConfiguredPersister persister = (ConfiguredPersister)Mockito.mock(ConfiguredPersister.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)persister.getId(ArgumentMatchers.any())).thenAnswer(invocationOnMock -> ((Toto)invocationOnMock.getArgument(0, Toto.class)).id);
        Mockito.when((Object)persister.isNew(ArgumentMatchers.any())).thenAnswer(invocationOnMock -> ((Toto)invocationOnMock.getArgument(0, Toto.class)).id == 0);
        Mockito.when((Object)persister.getMapping().getIdMapping().getIdentifierInsertionManager()).thenReturn(Mockito.mock(IdentifierInsertionManager.class));
        PersistExecutor result = PersistExecutor.forPersister((ConfiguredPersister)persister);
        Toto newEntity = new Toto(0);
        Toto existingEntity = new Toto(42);
        Mockito.when((Object)persister.select((Iterable)ArgumentMatchers.anyCollection())).thenAnswer(invocationOnMock -> Arrays.asSet((Object[])new Toto[]{existingEntity}));
        result.persist((Object[])new Toto[]{newEntity, existingEntity});
        ((ConfiguredPersister)Mockito.verify((Object)persister)).isNew((Object)newEntity);
        ((ConfiguredPersister)Mockito.verify((Object)persister)).isNew((Object)existingEntity);
        ((ConfiguredPersister)Mockito.verify((Object)persister)).insert((Iterable)Arrays.asSet((Object[])new Toto[]{newEntity}));
        ((ConfiguredPersister)Mockito.verify((Object)persister)).select((Iterable)Arrays.asHashSet((Object[])new Integer[]{existingEntity.id}));
        ((ConfiguredPersister)Mockito.verify((Object)persister)).update((Iterable)Arrays.asSet((Object[])new Duo[]{new Duo((Object)existingEntity, (Object)existingEntity)}), true);
    }

    @Test
    <T extends Table<T>> void forPersister_alreadyAssignedIdentifier_withoutManagingLambdas_persistIsBasedOnDatabaseSelect() {
        ConfiguredPersister persister = (ConfiguredPersister)Mockito.mock(ConfiguredPersister.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)persister.getId(ArgumentMatchers.any())).thenAnswer(invocationOnMock -> ((Toto)invocationOnMock.getArgument(0, Toto.class)).id);
        AlreadyAssignedIdentifierManager identifierManager = new AlreadyAssignedIdentifierManager(Integer.class, null, null);
        EntityMapping entityMappingMock = (EntityMapping)Mockito.mock(EntityMapping.class);
        Mockito.when((Object)persister.getMapping()).thenReturn((Object)entityMappingMock);
        IdMapping idMappingMock = (IdMapping)Mockito.mock(IdMapping.class);
        Mockito.when((Object)entityMappingMock.getIdMapping()).thenReturn((Object)idMappingMock);
        Mockito.when((Object)idMappingMock.getIdentifierInsertionManager()).thenReturn((Object)identifierManager);
        PersistExecutor result = PersistExecutor.forPersister((ConfiguredPersister)persister);
        Toto newEntity = new Toto(0);
        Toto existingEntity = new Toto(42);
        Mockito.when((Object)persister.select((Iterable)ArgumentMatchers.anyCollection())).thenAnswer(invocationOnMock -> Arrays.asSet((Object[])new Toto[]{existingEntity}));
        result.persist((Object[])new Toto[]{newEntity, existingEntity});
        ((ConfiguredPersister)Mockito.verify((Object)persister, (VerificationMode)Mockito.never())).isNew(ArgumentMatchers.any());
        ((ConfiguredPersister)Mockito.verify((Object)persister)).select((Iterable)Arrays.asHashSet((Object[])new Integer[]{existingEntity.id, newEntity.id}));
        ((ConfiguredPersister)Mockito.verify((Object)persister)).insert((Iterable)Arrays.asSet((Object[])new Toto[]{newEntity}));
        ((ConfiguredPersister)Mockito.verify((Object)persister)).update((Iterable)Arrays.asSet((Object[])new Duo[]{new Duo((Object)existingEntity, (Object)existingEntity)}), true);
    }

    @Test
    <T extends Table<T>> void forPersister_alreadyAssignedIdentifier_withManagingLambdas_persistIsBasedOnDatabaseSelect() {
        ConfiguredPersister persister = (ConfiguredPersister)Mockito.mock(ConfiguredPersister.class, (Answer)Mockito.RETURNS_MOCKS);
        HashSet<Toto> existingEntities = new HashSet<Toto>();
        Mockito.when((Object)persister.getId(ArgumentMatchers.any())).thenAnswer(invocationOnMock -> ((Toto)invocationOnMock.getArgument(0, Toto.class)).id);
        Mockito.when((Object)persister.isNew(ArgumentMatchers.any())).thenAnswer(invocationOnMock -> !existingEntities.contains(invocationOnMock.getArgument(0, Toto.class)));
        AlreadyAssignedIdentifierManager identifierManager = new AlreadyAssignedIdentifierManager(Integer.class, existingEntities::add, existingEntities::contains);
        EntityMapping entityMappingMock = (EntityMapping)Mockito.mock(EntityMapping.class);
        Mockito.when((Object)persister.getMapping()).thenReturn((Object)entityMappingMock);
        IdMapping idMappingMock = (IdMapping)Mockito.mock(IdMapping.class);
        Mockito.when((Object)entityMappingMock.getIdMapping()).thenReturn((Object)idMappingMock);
        Mockito.when((Object)idMappingMock.getIdentifierInsertionManager()).thenReturn((Object)identifierManager);
        PersistExecutor result = PersistExecutor.forPersister((ConfiguredPersister)persister);
        Toto newEntity = new Toto(0);
        Toto existingEntity = new Toto(42);
        existingEntities.add(existingEntity);
        Mockito.when((Object)persister.select((Iterable)ArgumentMatchers.anyCollection())).thenAnswer(invocationOnMock -> Arrays.asSet((Object[])new Toto[]{existingEntity}));
        result.persist((Object[])new Toto[]{newEntity, existingEntity});
        ((ConfiguredPersister)Mockito.verify((Object)persister)).isNew((Object)newEntity);
        ((ConfiguredPersister)Mockito.verify((Object)persister)).isNew((Object)existingEntity);
        ((ConfiguredPersister)Mockito.verify((Object)persister)).select((Iterable)Arrays.asHashSet((Object[])new Integer[]{existingEntity.id}));
        ((ConfiguredPersister)Mockito.verify((Object)persister)).insert((Iterable)Arrays.asSet((Object[])new Toto[]{newEntity}));
        ((ConfiguredPersister)Mockito.verify((Object)persister)).update((Iterable)Arrays.asSet((Object[])new Duo[]{new Duo((Object)existingEntity, (Object)existingEntity)}), true);
    }

    private static class Toto {
        private int id;
        private String prop;

        public Toto(int id) {
            this.id = id;
        }

        public Toto(int id, String prop) {
            this.id = id;
            this.prop = prop;
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setProp(String prop) {
            this.prop = prop;
        }
    }
}

